/*
  Qtechknow Creator Kit: Circuit 8 - KnobRGB
  
  Uses the built-in RGB LED on the Qduino Mini and the
  knob included in the Creator Kit - when the knob is
  turned, the color of the RGB LED changes.
 
  created by Julian White
  modified by Qtechknow
*/
 
int redPin = 10;  // declare the RGB LED pins
int greenPin = 11;
int bluePin = 13;

int knobPin = A0;  // pin where knob is connected
int val = 0;

void setup() {
  
    pinMode(redPin, OUTPUT);  // declare pins as outputs
    pinMode(greenPin, OUTPUT);
    pinMode(bluePin, OUTPUT);
}

void loop()
{
    //Read the potentiometer (color wheel).
    val = analogRead(knobPin);

    //Red-orange-yellow-green spectrum
    if ( val <= 341 )
    {
        //We now know the val is between 0 and 341.
        //Map the val to 0-255 for the LED.
        val = map(val, 0, 341, 0, 255);
        
        //Higher val turns red down.
        //Lower val turns red up (common anode).
        analogWrite(redPin, val);
        
        //Write the complimentary amount to the green pin.
        //The mixed color values add up to 255.
        //This keeps the LED at constant brightness.
        analogWrite(greenPin, 255-val);
        
        //Turn blue pin off.
        analogWrite(bluePin, 255);
    }
    
    //Green-teal-blue spectrum
    else if ( val <= 683 )
    {
        //We now know the val is between 341 and 683.
        //Map the val to 0-255 for the LED.
        val = map(val, 341, 683, 0, 255);
        
        //Higher val turns green down.
        //Lower val turns green up (common anode).
        analogWrite(greenPin, val);
        
        //Write the complimentary amount to the blue pin.
        //The mixed color values add up to 255.
        //This keeps the LED at constant brightness.
        analogWrite(bluePin, 255-val);
        
        //Turn red pin off.
        analogWrite(redPin, 255);
    }
    
    //Blue-indigo-purple-red spectrum.
    else
    {
        //We now know the val is between 683 and 1023.
        //Map the val to 0-255 for the LED.
        val = map(val, 683, 1023, 0, 255);
        
        //Higher val turns blue down.
        //Lower val turns blue up (common anode).
        analogWrite(bluePin, val);

        //Write the complimentary amount to the red pin.
        //The mixed color values add up to 255.
        //This keeps the LED at constant brightness.
        analogWrite(redPin, 255-val);

        //Turn green pin off.
        analogWrite(greenPin, 255);
    }
    
    //Sampling rate.
    delay(20);
}
